/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.idm.toolkit.expr;

import filenet.vw.base.VWString;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.IVWIDMPropertyDescription;
import filenet.vw.idm.toolkit.expr.VWIDMLexer;
import filenet.vw.idm.toolkit.expr.VWIDMToken;
import java.util.GregorianCalendar;
import java.util.Hashtable;

public class VWIDMExprEmit {
    private VWIDMLexer myLexer = null;
    private boolean bBadIdentToken = false;
    private boolean bGotError = false;
    private boolean bAlreadyGotBadOperand = false;
    private Hashtable theYaccErrors = null;
    private boolean debug = false;
    protected static final int AndOpCode = 1;
    protected static final int OrOpCode = 2;
    protected static final int NotOpCode = 3;
    protected static final int EQOpCode = 4;
    protected static final int NEOpCode = 5;
    protected static final int GTOpCode = 6;
    protected static final int LTOpCode = 7;
    protected static final int GEOpCode = 8;
    protected static final int LEOpCode = 9;
    protected static final int AddOpCode = 10;
    protected static final int LikeOpCode = 11;
    protected static final int NotLikeOpCode = 12;
    protected static final int MinusOpCode = 13;

    protected VWIDMExprEmit() {
    }

    protected VWIDMExprEmit(VWIDMLexer theLexer, Hashtable yaccErrors, boolean doDebug) {
        this.theYaccErrors = yaccErrors;
        this.myLexer = theLexer;
        this.debug = doDebug;
    }

    protected boolean gotError() {
        return this.bGotError;
    }

    protected boolean isBadIdentToken() {
        return this.bBadIdentToken;
    }

    protected VWIDMToken getPropertyToken(String name, IVWIDMPropertyDescription[] propDesc, IVWIDMItem document, boolean evaluate, boolean doDebug) {
        VWIDMToken propToken = new VWIDMToken(name, propDesc, document, evaluate, doDebug);
        if (propToken.isBadIdentToken()) {
            this.bBadIdentToken = true;
            VWString theMessage = new VWString("vw.api.VWIDMExpValidationBadPropName", "The name \"{0}\" in the expression is not a valid property name.", name);
            this.addError(theMessage);
        }
        return propToken;
    }

    protected Object processOp(int opCodeType, VWIDMToken token1, VWIDMToken token2, boolean evaluate) {
        VWIDMToken result = null;
        boolean typesOk = false;
        boolean valueOk = true;
        this.PrintDebug("\nToken1 type: " + token1.getType());
        this.PrintDebug("Token1 value: " + token1.getValue());
        this.PrintDebug("Token2 type: " + token2.getType());
        this.PrintDebug("Token2 value: " + token2.getValue());
        this.doFixUpConversion(token1, token2, evaluate);
        int bestType = this.findBestType(token1, token2);
        typesOk = this.checkTypesWithOperand(token1.getType(), token2.getType(), opCodeType);
        if (bestType != -1 && typesOk) {
            if (evaluate) {
                switch (bestType) {
                    case 1: {
                        result = this.compareIntegers(token1, token2, opCodeType);
                        break;
                    }
                    case 8: {
                        result = this.compareDoubles(token1, token2, opCodeType);
                        break;
                    }
                    case 2: {
                        result = this.compareStrings(token1, token2, opCodeType);
                        break;
                    }
                    case 16: {
                        result = this.compareDates(token1, token2, opCodeType);
                        break;
                    }
                    case 4: {
                        result = this.compareBooleans(token1, token2, opCodeType);
                        break;
                    }
                    default: {
                        result = new VWIDMToken(null, 32, false, this.debug);
                        break;
                    }
                }
            } else {
                String propName = null;
                String strValue = null;
                result = new VWIDMToken(null, this.getOpResultType(opCodeType), false, this.debug);
                if (token1.isPropertyToken() && token2.isPropertyToken()) {
                    valueOk = true;
                } else if (token1.isPropertyToken()) {
                    valueOk = token1.isValidChoice(token2);
                    propName = token1.getPropertyName();
                    strValue = token2.getStringValue();
                } else if (token2.isPropertyToken()) {
                    valueOk = token2.isValidChoice(token1);
                    propName = token2.getPropertyName();
                    strValue = token1.getStringValue();
                }
                if (!valueOk) {
                    VWString theMessage = new VWString("vw.api.VWIDMExpValidationBadChoice", "\"{0}\" is an invalid CVL value for property {1}.", strValue, propName);
                    this.addError(theMessage);
                }
            }
        } else {
            result = new VWIDMToken(null, -1, false, this.debug);
        }
        return result;
    }

    private VWIDMToken compareDates(VWIDMToken tk1, VWIDMToken tk2, int opCodeType) {
        int i;
        long[] val1Arr = new long[1];
        long[] val2Arr = new long[1];
        Object tmp = null;
        Object[] tmpArr = null;
        boolean result = false;
        if (tk1.getValue() != null) {
            if (tk1.isMultiValue()) {
                tmpArr = (Object[])tk1.getValue();
                val1Arr = new long[tmpArr.length];
                if (tk1.getType() == 16) {
                    for (i = 0; i < tmpArr.length; ++i) {
                        val1Arr[i] = ((GregorianCalendar)tmpArr[i]).getTime().getTime();
                    }
                }
            } else {
                val1Arr[0] = ((GregorianCalendar)tk1.getValue()).getTime().getTime();
            }
        }
        if (tk2.getValue() != null) {
            if (tk2.isMultiValue()) {
                tmpArr = (Object[])tk2.getValue();
                val2Arr = new long[tmpArr.length];
                if (tk2.getType() == 16) {
                    for (i = 0; i < tmpArr.length; ++i) {
                        val2Arr[i] = ((GregorianCalendar)tmpArr[i]).getTime().getTime();
                    }
                }
            } else {
                val2Arr[0] = ((GregorianCalendar)tk2.getValue()).getTime().getTime();
            }
        }
        if (val1Arr != null && val2Arr != null) {
            switch (opCodeType) {
                case 6: {
                    if (tk1.getValue() == null || tk2.getValue() == null) break;
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (val1Arr[i] <= val2Arr[j]) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 8: {
                    if (tk1.getValue() == null || tk2.getValue() == null) {
                        result = tk1.getValue() == tk2.getValue();
                        break;
                    }
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (val1Arr[i] < val2Arr[j]) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 7: {
                    if (tk1.getValue() == null || tk2.getValue() == null) break;
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (val1Arr[i] >= val2Arr[j]) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 9: {
                    if (tk1.getValue() == null || tk2.getValue() == null) {
                        result = tk1.getValue() == tk2.getValue();
                        break;
                    }
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (val1Arr[i] > val2Arr[j]) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 5: {
                    if (tk1.getValue() == null || tk2.getValue() == null) {
                        result = tk1.getValue() != tk2.getValue();
                        break;
                    }
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (val1Arr[i] == val2Arr[j]) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 4: {
                    if (tk1.getValue() == null || tk2.getValue() == null) {
                        result = tk1.getValue() == tk2.getValue();
                        break;
                    }
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (val1Arr[i] != val2Arr[j]) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 13: {
                    this.throwBadOperandTypes();
                }
            }
            return new VWIDMToken(new Boolean(result), 4, false, this.debug);
        }
        this.PrintDebug("compareDates() had a null array.");
        return new VWIDMToken(null, 32, false, this.debug);
    }

    private VWIDMToken compareIntegers(VWIDMToken tk1, VWIDMToken tk2, int opCodeType) {
        int i;
        int[] val1Arr = new int[1];
        int[] val2Arr = new int[1];
        Object tmp = null;
        Object[] tmpArr = null;
        boolean result = false;
        if (tk1.getValue() != null) {
            if (tk1.isMultiValue()) {
                tmpArr = (Object[])tk1.getValue();
                val1Arr = new int[tmpArr.length];
                for (i = 0; i < tmpArr.length; ++i) {
                    val1Arr[i] = (Integer)tmpArr[i];
                }
            } else {
                val1Arr[0] = (Integer)tk1.getValue();
            }
        }
        if (tk2.getValue() != null) {
            if (tk2.isMultiValue()) {
                tmpArr = (Object[])tk2.getValue();
                val2Arr = new int[tmpArr.length];
                for (i = 0; i < tmpArr.length; ++i) {
                    val2Arr[i] = (Integer)tmpArr[i];
                }
            } else {
                val2Arr[0] = (Integer)tk2.getValue();
            }
        }
        if (val1Arr != null && val2Arr != null) {
            switch (opCodeType) {
                case 6: {
                    if (tk1.getValue() == null || tk2.getValue() == null) break;
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (val1Arr[i] <= val2Arr[j]) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 8: {
                    if (tk1.getValue() == null || tk2.getValue() == null) {
                        result = tk1.getValue() == tk2.getValue();
                        break;
                    }
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (val1Arr[i] < val2Arr[j]) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 7: {
                    if (tk1.getValue() == null || tk2.getValue() == null) break;
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (val1Arr[i] >= val2Arr[j]) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 9: {
                    if (tk1.getValue() == null || tk2.getValue() == null) {
                        result = tk1.getValue() == tk2.getValue();
                        break;
                    }
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (val1Arr[i] > val2Arr[j]) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 5: {
                    if (tk1.getValue() == null || tk2.getValue() == null) {
                        result = tk1.getValue() != tk2.getValue();
                        break;
                    }
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (val1Arr[i] == val2Arr[j]) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 4: {
                    if (tk1.getValue() == null || tk2.getValue() == null) {
                        result = tk1.getValue() == tk2.getValue();
                        break;
                    }
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (val1Arr[i] != val2Arr[j]) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 13: {
                    if (tk1.getValue() == null || tk1.getType() == 32) {
                        return new VWIDMToken(null, 32, false, this.debug);
                    }
                    if (tk1.isMultiValue()) {
                        tmpArr = new Object[val1Arr.length];
                        for (i = 0; i < tmpArr.length; ++i) {
                            tmpArr[i] = new Integer(val1Arr[i] * -1);
                        }
                        return new VWIDMToken(tmpArr, 1, true, this.debug);
                    }
                    return new VWIDMToken(new Integer(val1Arr[0] * -1), 1, false, this.debug);
                }
                case 1: 
                case 2: 
                case 3: {
                    this.throwBadOperandTypes();
                }
            }
            return new VWIDMToken(new Boolean(result), 4, false, this.debug);
        }
        this.PrintDebug("compareIntegers() had a null array.");
        return new VWIDMToken(null, 32, false, this.debug);
    }

    private VWIDMToken compareBooleans(VWIDMToken tk1, VWIDMToken tk2, int opCodeType) {
        int i;
        boolean[] val1Arr = new boolean[1];
        boolean[] val2Arr = new boolean[1];
        Object tmp = null;
        Object[] tmpArr = null;
        boolean result = false;
        if (tk1.getValue() == null) {
            val1Arr[0] = false;
        } else if (tk1.isMultiValue()) {
            tmpArr = (Object[])tk1.getValue();
            val1Arr = new boolean[tmpArr.length];
            for (i = 0; i < tmpArr.length; ++i) {
                val1Arr[i] = (Boolean)tmpArr[i];
            }
        } else {
            val1Arr[0] = (Boolean)tk1.getValue();
        }
        if (tk2.getValue() == null) {
            val2Arr[0] = false;
        } else if (tk2.isMultiValue()) {
            tmpArr = (Object[])tk2.getValue();
            val2Arr = new boolean[tmpArr.length];
            for (i = 0; i < tmpArr.length; ++i) {
                val2Arr[i] = (Boolean)tmpArr[i];
            }
        } else {
            val2Arr[0] = (Boolean)tk2.getValue();
        }
        if (val1Arr != null && val2Arr != null) {
            switch (opCodeType) {
                case 6: {
                    if (tk1.getValue() == null || tk2.getValue() == null) break;
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (!val1Arr[i] || val2Arr[j]) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 8: {
                    if (tk1.getValue() == null || tk2.getValue() == null) {
                        result = tk1.getValue() == tk2.getValue();
                        break;
                    }
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (!val1Arr[i] && val2Arr[j]) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 7: {
                    if (tk1.getValue() == null || tk2.getValue() == null) break;
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (val1Arr[i] || !val2Arr[j]) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 9: {
                    if (tk1.getValue() == null || tk2.getValue() == null) {
                        result = tk1.getValue() == tk2.getValue();
                        break;
                    }
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (val1Arr[i] && val2Arr[j]) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 5: {
                    if (tk1.getValue() == null || tk2.getValue() == null) {
                        result = tk1.getValue() != tk2.getValue();
                        break;
                    }
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (val1Arr[i] == val2Arr[j]) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 4: {
                    if (tk1.getValue() == null || tk2.getValue() == null) {
                        result = tk1.getValue() == tk2.getValue();
                        break;
                    }
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (val1Arr[i] != val2Arr[j]) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 1: {
                    if (tk1.getValue() == null || tk2.getValue() == null) break;
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (!val1Arr[i] || !val2Arr[j]) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 2: {
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (!val1Arr[i] && !val2Arr[j]) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 3: {
                    if (tk1.getValue() == null) break;
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (val1Arr[i]) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 13: {
                    this.throwBadOperandTypes();
                }
            }
            return new VWIDMToken(new Boolean(result), 4, false, this.debug);
        }
        this.PrintDebug("compareBooleans() had a null array.");
        return new VWIDMToken(null, 32, false, this.debug);
    }

    private VWIDMToken compareDoubles(VWIDMToken tk1, VWIDMToken tk2, int opCodeType) {
        int i;
        double[] val1Arr = new double[1];
        double[] val2Arr = new double[1];
        Object tmp = null;
        Object[] tmpArr = null;
        boolean result = false;
        if (tk1.getValue() != null) {
            if (tk1.isMultiValue()) {
                tmpArr = (Object[])tk1.getValue();
                val1Arr = new double[tmpArr.length];
                if (tk1.getType() == 8) {
                    for (i = 0; i < tmpArr.length; ++i) {
                        val1Arr[i] = (Double)tmpArr[i];
                    }
                } else if (tk1.getType() == 1) {
                    for (i = 0; i < tmpArr.length; ++i) {
                        val1Arr[i] = ((Integer)tmpArr[i]).doubleValue();
                    }
                }
            } else if (tk1.getType() == 8) {
                val1Arr[0] = (Double)tk1.getValue();
            } else if (tk1.getType() == 1) {
                val1Arr[0] = ((Integer)tk1.getValue()).doubleValue();
            }
        }
        if (tk2.getValue() != null) {
            if (tk2.isMultiValue()) {
                tmpArr = (Object[])tk2.getValue();
                val2Arr = new double[tmpArr.length];
                if (tk2.getType() == 8) {
                    for (i = 0; i < tmpArr.length; ++i) {
                        val2Arr[i] = (Double)tmpArr[i];
                    }
                } else if (tk2.getType() == 1) {
                    for (i = 0; i < tmpArr.length; ++i) {
                        val2Arr[i] = ((Integer)tmpArr[i]).doubleValue();
                    }
                }
            } else if (tk2.getType() == 8) {
                val2Arr[0] = (Double)tk2.getValue();
            } else if (tk2.getType() == 1) {
                val2Arr[0] = ((Integer)tk2.getValue()).doubleValue();
            }
        }
        if (val1Arr != null && val2Arr != null) {
            switch (opCodeType) {
                case 6: {
                    if (tk1.getValue() == null || tk2.getValue() == null) break;
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (!(val1Arr[i] > val2Arr[j])) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 8: {
                    if (tk1.getValue() == null || tk2.getValue() == null) {
                        result = tk1.getValue() == tk2.getValue();
                        break;
                    }
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (!(val1Arr[i] >= val2Arr[j])) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 7: {
                    if (tk1.getValue() == null || tk2.getValue() == null) break;
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (!(val1Arr[i] < val2Arr[j])) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 9: {
                    if (tk1.getValue() == null || tk2.getValue() == null) {
                        result = tk1.getValue() == tk2.getValue();
                        break;
                    }
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (!(val1Arr[i] <= val2Arr[j])) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 5: {
                    if (tk1.getValue() == null || tk2.getValue() == null) {
                        result = tk1.getValue() != tk2.getValue();
                        break;
                    }
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (val1Arr[i] == val2Arr[j]) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 4: {
                    if (tk1.getValue() == null || tk2.getValue() == null) {
                        result = tk1.getValue() == tk2.getValue();
                        break;
                    }
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (val1Arr[i] != val2Arr[j]) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 13: {
                    if (tk1.getValue() == null || tk1.getType() == 32) {
                        return new VWIDMToken(null, 32, false, this.debug);
                    }
                    if (tk1.isMultiValue()) {
                        tmpArr = new Object[val1Arr.length];
                        for (i = 0; i < tmpArr.length; ++i) {
                            tmpArr[i] = new Double(val1Arr[i] * -1.0);
                        }
                        return new VWIDMToken(tmpArr, 8, true, this.debug);
                    }
                    return new VWIDMToken(new Double(val1Arr[0] * -1.0), 8, false, this.debug);
                }
                case 1: 
                case 2: 
                case 3: {
                    this.throwBadOperandTypes();
                }
            }
            return new VWIDMToken(new Boolean(result), 4, false, this.debug);
        }
        this.PrintDebug("compareDoubles() had a null array.");
        return new VWIDMToken(null, 32, false, this.debug);
    }

    private VWIDMToken compareStrings(VWIDMToken tk1, VWIDMToken tk2, int opCodeType) {
        int i;
        String[] val1Arr = new String[1];
        String[] val2Arr = new String[1];
        Object tmp = null;
        Object[] tmpArr = null;
        boolean result = false;
        if (tk1.getValue() != null) {
            if (tk1.isMultiValue()) {
                tmpArr = (Object[])tk1.getValue();
                val1Arr = new String[tmpArr.length];
                for (i = 0; i < tmpArr.length; ++i) {
                    val1Arr[i] = tmpArr[i] != null ? (String)tmpArr[i] : "";
                }
            } else {
                val1Arr[0] = tk1.getValue() != null ? (String)tk1.getValue() : "";
            }
        } else {
            val1Arr[0] = "";
        }
        if (tk2.getValue() != null) {
            if (tk2.isMultiValue()) {
                tmpArr = (Object[])tk2.getValue();
                val2Arr = new String[tmpArr.length];
                for (i = 0; i < tmpArr.length; ++i) {
                    val2Arr[i] = tmpArr[i] != null ? (String)tmpArr[i] : "";
                }
            } else {
                val2Arr[0] = tk2.getValue() != null ? (String)tk2.getValue() : "";
            }
        } else {
            val2Arr[0] = "";
        }
        if (val1Arr != null && val2Arr != null) {
            switch (opCodeType) {
                case 6: {
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (val1Arr[i].compareTo(val2Arr[j]) <= 0) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 8: {
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (val1Arr[i].compareTo(val2Arr[j]) < 0) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 7: {
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (val1Arr[i].compareTo(val2Arr[j]) >= 0) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 9: {
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (val1Arr[i].compareTo(val2Arr[j]) > 0) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 5: {
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (val1Arr[i].compareTo(val2Arr[j]) == 0) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 4: {
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (val1Arr[i].compareTo(val2Arr[j]) != 0) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 11: {
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (val1Arr[i].indexOf(val2Arr[j]) == -1) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 12: {
                    for (i = 0; i < val1Arr.length; ++i) {
                        for (int j = 0; j < val2Arr.length; ++j) {
                            if (val1Arr[i].indexOf(val2Arr[j]) != -1) continue;
                            result = true;
                        }
                    }
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.throwBadOperandTypes();
                }
            }
            return new VWIDMToken(new Boolean(result), 4, false, this.debug);
        }
        this.PrintDebug("compareStrings() had a null array.");
        return new VWIDMToken(null, 32, false, this.debug);
    }

    private void doFixUpConversion(VWIDMToken tk1, VWIDMToken tk2, boolean doingEvaluate) {
        if (doingEvaluate) {
            try {
                if (tk1.isPropertyToken() && tk1.getType() == 2 && tk1.getValue() != null && tk2.getType() == 1 && (!tk2.isPropertyToken() || tk2.getValue() == null)) {
                    if (tk2.getValue() != null) {
                        Integer val = (Integer)tk2.getValue();
                        tk2.setValue(val.toString());
                    }
                    tk2.setType(2);
                } else if (tk2.isPropertyToken() && tk2.getType() == 2 && tk2.getValue() != null && tk1.getType() == 1 && (!tk1.isPropertyToken() || tk1.getValue() == null)) {
                    if (tk1.getValue() != null) {
                        Integer val = (Integer)tk1.getValue();
                        tk1.setValue(val.toString());
                    }
                    tk1.setType(2);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    private int findBestType(VWIDMToken tk1, VWIDMToken tk2) {
        int type1 = tk1.getType();
        int type2 = tk2.getType();
        int newType = type1;
        block0 : switch (type1) {
            case 1: {
                switch (type2) {
                    case 1: 
                    case 8: {
                        newType = type2;
                        break block0;
                    }
                    case 32: {
                        newType = 32;
                        break block0;
                    }
                }
                this.throwBadOperandTypes();
                newType = -1;
                break;
            }
            case 8: {
                switch (type2) {
                    case 1: 
                    case 8: {
                        break block0;
                    }
                    case 32: {
                        newType = 32;
                        break block0;
                    }
                }
                this.throwBadOperandTypes();
                newType = -1;
                break;
            }
            case 2: {
                switch (type2) {
                    case 16: {
                        if (tk1.isPropertyToken()) {
                            this.throwBadOperandTypes();
                            newType = -1;
                            break;
                        }
                        if (tk1.getValue() == null) break block0;
                        GregorianCalendar gc = VWIDMToken.getDateValue((String)tk1.getValue());
                        if (gc != null) {
                            tk1.setValue(gc);
                            tk1.setType(16);
                            newType = type2;
                            break;
                        }
                        this.throwBadOperandTypes();
                        newType = -1;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 32: {
                        newType = 32;
                        break;
                    }
                    default: {
                        this.throwBadOperandTypes();
                        newType = -1;
                        break;
                    }
                }
                break;
            }
            case 4: {
                switch (type2) {
                    case 4: 
                    case 32: {
                        break block0;
                    }
                }
                this.throwBadOperandTypes();
                newType = -1;
                break;
            }
            case 16: {
                switch (type2) {
                    case 16: {
                        break;
                    }
                    case 2: {
                        if (tk2.isPropertyToken()) {
                            this.throwBadOperandTypes();
                            newType = -1;
                            break;
                        }
                        if (tk2.getValue() == null) break block0;
                        GregorianCalendar gc = VWIDMToken.getDateValue((String)tk2.getValue());
                        if (gc != null) {
                            tk2.setValue(gc);
                            tk2.setType(16);
                            break;
                        }
                        this.throwBadOperandTypes();
                        newType = -1;
                        break;
                    }
                    case 32: {
                        newType = 32;
                        break;
                    }
                    default: {
                        this.throwBadOperandTypes();
                        newType = -1;
                        break;
                    }
                }
                break;
            }
            case 32: {
                switch (type2) {
                    case 1: 
                    case 2: 
                    case 8: 
                    case 16: 
                    case 32: {
                        break block0;
                    }
                    case 4: {
                        newType = 4;
                        break block0;
                    }
                }
                this.throwBadOperandTypes();
                newType = -1;
                break;
            }
            default: {
                this.throwBadOperandTypes();
                newType = -1;
            }
        }
        return newType;
    }

    private boolean checkTypesWithOperand(int type1, int type2, int opCodeType) {
        boolean result = true;
        switch (opCodeType) {
            case 1: 
            case 2: {
                if ((type1 == 4 || type1 == 32) && (type2 == 4 || type2 == 32)) break;
                result = false;
                break;
            }
            case 3: {
                if (type1 == 4 || type1 == 32) break;
                result = false;
                break;
            }
            case 11: 
            case 12: {
                if (type1 == 2 && type2 == 2) break;
                result = false;
                break;
            }
            case 13: {
                if (type1 == 1 || type1 == 8 || type1 == 32) break;
                result = false;
            }
        }
        if (!result) {
            this.throwBadOperandTypes();
        }
        return result;
    }

    private int getOpResultType(int opCodeType) {
        int theType = -1;
        switch (opCodeType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                theType = 4;
                break;
            }
            case 13: {
                theType = 1;
                break;
            }
            default: {
                theType = -1;
            }
        }
        return theType;
    }

    private boolean isValidDateString(String dateString) {
        GregorianCalendar theDate = VWIDMToken.getDateValue(dateString);
        return theDate != null;
    }

    private void addError(VWString theMessage) {
        this.bGotError = true;
        this.theYaccErrors.put(new Integer(this.theYaccErrors.size()), theMessage);
    }

    private void throwBadOperandTypes() {
        if (!this.bAlreadyGotBadOperand) {
            VWString theMessage = new VWString("vw.api.VWExprEmitBadOperand", "Got a bad type for operand(s) in the expression.   Offset: {0}", new Integer(this.myLexer.getLineOffset()));
            this.addError(theMessage);
            this.bAlreadyGotBadOperand = true;
        }
    }

    private void PrintDebug(String msg) {
        if (this.debug) {
            System.out.println(msg);
        }
    }
}

